/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.james.tinkerscalibration.Utils;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ResistModifier
extends Modifier
implements ProjectileLaunchModifierHook {
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.PROJECTILE_LAUNCH);
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
        if (primary && (arrow == null || arrow.m_36792_())) {
            int effectLevel = Math.min(6, ((TinkerEffect)TinkerModifiers.momentumRangedEffect.get()).getLevel(shooter) + 1);
            ((TinkerEffect)Utils.resistEffect.get()).apply(shooter, 60, effectLevel, true);
        }
    }

    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        if (!context.isExtraAttack() && context.isFullyCharged()) {
            LivingEntity attacker = context.getAttacker();
            int effectLevel = Math.min(6, ((TinkerEffect)TinkerModifiers.insatiableEffect.get()).getLevel(attacker) + 1);
            ((TinkerEffect)Utils.resistEffect.get()).apply(attacker, 60, effectLevel, true);
        }
        return 0;
    }

    public boolean isSourceBlocked(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount) {
        int effect = ((TinkerEffect)Utils.resistEffect.get()).getLevel((LivingEntity)source.m_7639_());
        if (effect == 0) {
            return source.m_146707_();
        }
        if (effect == 1) {
            return source.m_146707_() || source.m_19384_();
        }
        if (effect == 2) {
            return source.m_146707_() || source.m_19384_() || source.m_19372_();
        }
        if (effect == 3) {
            return source.m_146707_() || source.m_19384_() || source.m_19372_() || source.m_19360_();
        }
        if (effect == 4) {
            return source.m_146707_() || source.m_19384_() || source.m_19372_() || source.m_19360_() || source.m_19376_();
        }
        if (effect == 5) {
            return source.m_146707_() || source.m_19384_() || source.m_19372_() || source.m_19360_() || source.m_19376_() || source.m_19387_();
        }
        return effect == 6;
    }
}

